/*
 * Decompiled with CFR 0.152.
 */
package xyz.przemyk.simpleplanes.capability;

import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import xyz.przemyk.simpleplanes.capability.CapClientConfig;

public class CapClientConfigProvider
implements ICapabilitySerializable<CompoundTag> {
    public static Capability<CapClientConfig> CLIENT_CONFIG_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<CapClientConfig>(){});
    private CapClientConfig capClientConfig = null;
    private final LazyOptional<CapClientConfig> clientConfigLazyOptional = LazyOptional.of(this::createClientConfig);

    private CapClientConfig createClientConfig() {
        if (this.capClientConfig == null) {
            this.capClientConfig = new CapClientConfig();
        }
        return this.capClientConfig;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == CLIENT_CONFIG_CAP) {
            return this.clientConfigLazyOptional.cast();
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        this.createClientConfig().save(compoundTag);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        this.createClientConfig().load(compoundTag);
    }

    public void invalidate() {
        this.clientConfigLazyOptional.invalidate();
    }
}

